Option Explicit

Const scriptName = "Equally Space Horizontally"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - MJM - Initial Release.



' Script constants, questions, and error messages.
Const errWrongSelection = "Please select at least two elements."
Const errConvertFailedPrefix = "Could not convert "
Const errConvertFailedSuffix = " to points."

Const kDefaultSpace = 18
Const qSpace = "Put how much space between these elements?"

' Enums

' enum crMeasurementUnits
Const crHorizontalRulerUnits = 0
Const crVerticalRulerUnits = 1
Const crAgates = 2
Const crCentimeters = 3
Const crCiceros = 4
Const crDecimalInches = 5
Const crFractionalInches = 6
Const crMillimeters = 7
Const crPicas = 8
Const crPicasAndPoints = 9
Const crPoints = 10
Const crPrintersPoints = 11


' enum crAlignmentType
Const crLeftEdges = 0
Const crHorizontalCenters = 1
Const crRightEdges = 2
Const crTops = 3
Const crVerticalCenters = 4
Const crBottoms = 5
Const crCenters = 6



' Main

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim sel
Dim selCount
Dim continueOn
continueOn = True

Err.Clear
On Error Resume Next
Set sel = CreatorApp.Selection
continueOn = (Err.Number = 0)
On Error GoTo 0

If continueOn Then
  selCount = sel.Count
  continueOn = (selCount > 1)
End If

If Not continueOn Then
    Call MsgBox(errWrongSelection, vbOkonly, scriptName)
End If

  
Dim theAnswer
Dim spaceVal
If continueOn Then
  ' Get space
  Dim defaultAnswer
  defaultAnswer = CreatorApp.ConvertToMeasurement(kDefaultSpace, crHorizontalRulerUnits)
  
  Dim loopDone
  loopDone = False
  Do
    theAnswer = InputBox(qSpace, scriptName, defaultAnswer)
    loopDone = (theAnswer = "")

    If loopDone Then
      continueOn = False
    ' consider asking if they want to convert
    'ElseIf IsNumeric(theAnswer) Then
    '  spaceVal = CDbl(theAnswer)
    '  loopDone = True
    Else
      Err.Clear
      On Error Resume Next
      spaceVal = CreatorApp.ConvertToPoints(theAnswer)
      If Err.Number = 0 Then
        loopDone = True
	continueOn = True
      Else
        Call MsgBox(errConvertFailedPrefix & theAnswer & errConvertFailedSuffix, vbOkonly, scriptname)
	defaultAnswer = theAnswer
      End If
      On Error Goto 0
    End If
  Loop Until loopDone
End If
  
If continueOn Then
  ' Sort elements by transformed lefts
  Dim elementArray(), leftArray(), modArray()
  ReDim elementArray(selCount)
  ReDim leftArray(selCount)
  ReDim modArray(selCount)
  Dim i
  For i = 1 To selCount
    Set elementArray(i) = sel(i)
    leftArray(i) = elementArray(i).Left
    modArray(i) = 0
    If (elementArray(i).Rotation <> 0) Or (elementArray(i).SkewAngle <> 0) Or (elementArray(i).Flipped) Then
      Call elementArray(i).Align(crLeftEdges, 0)
      leftArray(i) =  leftArray(i) - elementArray(i).Left
      CreatorApp.Undo
      
      Call elementArray(i).Align(crRightEdges, 0)
      modArray(i) = elementArray(i).Right
      CreatorApp.Undo
    End If
  Next
  
  ' stupid bubble sort
  Dim j
  Dim didSomething
 
  For i = 1 To selCount - 1
    didSomething = False
    For j = 1 To selCount - i
      If (leftArray(j) > leftArray(j + 1)) Then
        Set elementArray(0) = elementArray(j)
        Set elementArray(j) = elementArray(j + 1)
        Set elementArray(j + 1) = elementArray(0)
        Set elementArray(0) = Nothing

	If (leftArray(j) <> leftArray(j + 1)) Then
          leftArray(0) = leftArray(j)
          leftArray(j) = leftArray(j + 1)
          leftArray(j + 1) = leftArray(0)
          leftArray(0) = 0
	End If

	If (modArray(j) <> modArray(j + 1)) Then
          modArray(0) = modArray(j)
          modArray(j) = modArray(j + 1)
          modArray(j + 1) = modArray(0)
          modArray(0) = 0
        End If
  
	didSomething = True
      End If
    Next
    If Not didSomething Then
      Exit For
    End If
  Next
    
  For i = 2 To selCount
    Call elementArray(i).Align(crLeftEdges, elementArray(i-1).Right - modArray(i-1) + spaceVal)
  Next
End If

